#!/bin/sh

##
## 0. Parameter setting
##

##
allyears='2007 2008 2009 2010 2011 2012 2013 2014 2015 2016 2017 2018 2019'
testyears='2020'
#testyears='2015'
months='07'
start_day='26'
#end_day='26'
end_day='31'
time_series='00 03 06 09 12 15 18 21'
#time_series='00'
## Grids - modified by gyin 11-24-2020
#xnums='20 30 40 50 60 70 80'
#ynums='20 30 40 50 60 70 80'
#xnums='50'
#ynums='60'

# the x y used here is not the same as x/y in step01-training.sh (x-num of row, y-num of col)
xnum1='13' #11
xnum2='128' #130
ynum1='13'
ynum2='128'
#xnum1='53'
#xnum2='53'
#ynum1='60'
#ynum2='60'


## Range of feature vectors   (2xRG+1)x (2xRG+1) : e.g. RG=15: 31x31 grids =961 grids (almost 180km x180km) resolution: 0.6 deg 
#nums='961'
#rg2='15'
nums='441'
rg2='10'
##
## Hyper-parameter (Gamma)
#gm='0.5 0.05 0.005 0.0005 0.00005 0.000005 0.0000005 0.00000005'
gm='0.0000005'
## Hyper-parameter (Cost)
#c2='50 40 30 20 10 8 6 4 2 1'
c2='4'
## Hyper-parameter (Epsilon)
#ep='1.0 0.1 0.01 0.001 0.0001 0.00001'
ep='0.001'

##site name (siteA,siteB,siteC,siteD,siteE)
site='siteC'

echo ${allyears}
##
## 1. Machine learning (pre-process)  Make training & testing data 
##  
./step01.sh "${allyears}" "${testyears}" "${months}" "${xnum1}" "${xnum2}" "${ynum1}" "${ynum2}" "${nums}" "${rg2}" "${site}" "${start_day}" "${end_day}" "${time_series}"

##
## 2. Machine learning (main part)
##
./step02.sh "${allyears}" "${testyears}" "${months}" "${xnum1}" "${xnum2}" "${ynum1}" "${ynum2}" "${nums}" "${rg2}" "${gm}" "${c2}" "${ep}" "${start_day}" "${end_day}" "${time_series}"

##
## 3. CDF or CDFt
##
#./step03.sh "${allyears}" "${testyears}" "${months}"  "${xnum1}" "${xnum2}" "${ynum1}" "${ynum2}" "${rg2}" "${gm}" "${c2}" "${ep}" "${start_day}" "${end_day}" "${time_series}"






##
## 4. Post-processing (calculate statistics and plot figures)
##
#./step04.sh "${allyears}" "${testyears}" "${months}"  "${xnum1}" "${xnum2}" "${ynum1}" "${ynum2}" "${rg2}" "${gm}" "${c2}" "${ep}" "${site}" "${start_day}" "${end_day}" "${time_series}"
##
## 4. draw the figures (python matplotlib)
## 
## Box plot
#./step04-boxplot.sh
## Bar graph at each point
#./step04-pointplot.sh
## grid points in the domain 
#./step04-domainplot.sh

#rm *.py
rm boxplot.py
rm data-merge.py
rm g2svm
rm g2svm.f90
rm -f test.R1

