#!/bin/sh


if [ "$2" = "" ];then
echo Usage: $0 YYYY MM
exit
fi

YEAR=$1
MONTH=$2
STI2=$3
ENI2=$4
STJ2=$5
ENJ2=$6
NUM=$7
RG=$8

SITE=$9
if [ "$9" = "siteA" ];then
  ydim=134
  xdim=100
elif [ "$9" = "siteB" ];then
  ydim=134
  xdim=117
elif [ "$9" = "siteC" ];then
  ydim=100
  xdim=100
elif [ "$9" = "siteD" ];then
  ydim=84
  xdim=100
elif [ "$9" = "siteE" ];then
  ydim=84
  xdim=84
fi

AA=1
NUM2=$((${NUM}+${AA}))

#STI=6
#ENI=28
#STJ=4
#ENJ=30

#STI2=18
#ENI2=84
#STJ2=12
#ENJ2=90

###############
cat <<EOF > g2svm.f90
   program a2grd  
   parameter (nn1=${NUM})
   parameter (idim2=${ydim},jdim2=${xdim},nn2=249,nn2b=248) ! every 3 hours
   parameter (idim3=${ydim},jdim3=${xdim})
!!
   real mrain(idim3,jdim3,nn2b),mrain2(nn1,nn2b),mrain2b(nn1,nn2b)
   real mrainnm(idim3,jdim3,nn2b),mrainnm2(nn1,nn2b)
   real rrain(idim2,jdim2,nn2b),rrain2(nn1,nn2b)
!!
   integer ii3,nn3
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real dlon,dlat
   real lat5,lon5
   real rr,rr2,avemrain,summrain,avemrain2,summrain2
!!
   integer :: ii2,k,kk,irec2,irec3,ix,iy,iir
!!
   character :: y4m2*8,y4*4,m2*2,d2a*2,h2a*2
   character :: y4m2b*6
   character :: lon2*3,lat2*3
!!

!! aaa -----------------------------------------
!!-----------------------------------------
!!-----------------------------------------

! changed here for own mac address

! office mac path
!  OPEN (10,FILE='/Users/gyin/Documents/Research/ML/mlcdft-bin/MSMGPV/data1/${YEAR}${MONTH}/rsms-${YEAR}${MONTH}.grd' &

! my macbook pro path
! OPEN (10,FILE='/Users/gyin/Documents/Research/2020/mlcdft-bin/MSMGPV/data1/${YEAR}${MONTH}/rsms-${YEAR}${MONTH}.grd' &

! JAXA server path
  OPEN (10,FILE='/goemon_disk2/trmmauto/AI_GSMaP/svm-msm-wj-201906/MSMGPV/data1/${SITE}/${YEAR}${MONTH}/rsms-${YEAR}${MONTH}.grd' &
!    ,recl=idim2*jdim2,access='direct',status='old') !ifort
    ,recl=idim3*jdim3*4,access='direct',status='old') !gfortran


!   OPEN (20,FILE='/Users/gyin/Documents/Research/ML/mlcdft-bin/Radar_AMeDAS/data1/${YEAR}${MONTH}/radar-${YEAR}${MONTH}.grd' &
!  OPEN (20,FILE='/Users/gyin/Documents/Research/2020/mlcdft-bin/Radar_AMeDAS/data1/${YEAR}${MONTH}/radar-${YEAR}${MONTH}.grd' &
  OPEN (20,FILE='/goemon_disk2/trmmauto/AI_GSMaP/svm-msm-wj-201906/kaiseki/data1/${SITE}/${YEAR}${MONTH}/kaiseki-${YEAR}${MONTH}.grd' &
!    ,recl=idim2*jdim2,access='direct',status='old')  !ifirot
    ,recl=idim2*jdim2*4,access='direct',status='old')  !gfortran
!!!!
 irec2=1
 irec3=1
!!!!
 do k=2,nn2
     kk=k-1 !comment by gyin 11-24-2020: do not understand why not kk=1,nn2-1 -- but keep it here
!!
!!!!!!!!!!!!!!!!!!!!!
!!    GrADS INPUT
!!!!!!!!!!!!!!!!!!!!!
!! msm
    read(10,rec=irec2) ((mrain(i,j,kk),i=1,idim3),j=1,jdim3)
    irec2=irec2+3
!! radar
   read(20,rec=irec3) ((rrain(i,j,kk),i=1,idim2),j=1,jdim2)
    irec3=irec3+3
  end do
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!

 do ix= ${STI2},${ENI2}
  do iy= ${STJ2},${ENJ2}

 write(lon2,'(i3.3)') ix
 write(lat2,'(i3.3)') iy

!!!!
  OPEN (30,FILE='${YEAR}${MONTH}-svm_'//lon2//'_'//lat2//'.dat',status='unknown')
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!
 do k=2,nn2
     kk=k-1
   rr=rrain(ix,iy,kk)
   if(rr.le.0.101) then
     rr=0.0
   end if

!   if(rr.lt.0.) then
!     write(*,*) rr,ix,iy,kk
!   end if
   
!!
   ixs=int(ix)-${RG}
   ixe=int(ix)+${RG}
   iys=int(iy)-${RG}
   iye=int(iy)+${RG}
!
!!
  ii=1
!!   
   do i=ixs,ixe
    do j=iys,iye
       if(mrain(i,j,kk).ge.0.) then
        mrain2(ii,kk)=mrain(i,j,kk)
       else
        mrain2(ii,kk)=0       
       end if  
!!
    if(mrain2(ii,kk).lt.0.or.mrain2(ii,kk).ge.300.) then
     write(*,*) mrain2(ii,kk),ii,kk
    end if
!!
       ii=ii+1
!!
    end do  
   end do 
!!
!!
  if(rr.ge.0.) then
    write(30,'(${NUM2}f9.3)') (mrain2(m,kk),m=1,nn1),rr
  end if
!!
 end do !k
!!
 end do
end do
!!!!!!!!!!!!!!!!!!!!!
!!
  STOP
  END program a2grd
EOF
###############
chmod +x g2svm.f90
rm -f ./g2svm
#ifort -O -o g2svm g2svm.f90
gfortran -O -o  g2svm g2svm.f90
./g2svm

##############

#rm g2svm.f90
#rm g2svm

if [ ! -e ./data-training/${YEAR}${MONTH} ]; then
mkdir ./data-training/${YEAR}${MONTH}
fi
mv ${YEAR}${MONTH}-svm*.dat ./data-training/${YEAR}${MONTH}

#mkdir ./data-msm1/${YEAR}${MONTH}
#mv ${YEAR}${MONTH}-msm*.dat ./data-msm1/${YEAR}${MONTH}

###
## END grib2grads
###




