#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Programmed by RESTEC
based on Dr. Yoshikane's Program

"""
"""
Usage
> python3 ./step02-make_classifier3.py DIR2 gamma2 cost2 epsilon2 lon lat NUM2 NUM3
"""

"""
Installed library
 sklearn
 pandas
"""

import pandas as pd
from sklearn.svm import SVR
import pickle
import sys
#from sklearn.preprocessing import StandardScaler

args = sys.argv

DIR2 = args[1]
gamma2 =args[2]
cost2 = args[3]
epsilon2 = args[4]
lon = args[5]
lat = args[6]
NUM2 = args[7]
NUM3 = args[8]


#学習用データの読み込み
dat1 = pd.read_table(DIR2 + "/data-svm/svm_"+ lon + "_" + lat +".dat",delim_whitespace=True,header=None)

#欠損値の除外
#0より小さい値をNaNに置き換え
#dat1.where(dat1 >= 0)
#NaNの行を削除
#dat1.dropna(how='any')

#SVMでの学習
#トレーニングデータのデータセット作成
#目的変数をNUM3行とし、yに代入
y = dat1.iloc[:,int(NUM3)-1]
#説明変数をNUM2行までとし、Xに代入
X = dat1.iloc[:,0:int(NUM2)]

#パラメータの設定
mod1 = SVR(kernel='rbf',gamma=float(gamma2), C=float(cost2),epsilon=float(epsilon2))
#kernel:Radial Basis Function (RBF) 
#モデルの学習
mod1.fit(X,y)

#識別器の保存
with open(DIR2 + "/data-model/mod1_"+ lon + "_" + lat +"-gamma_"+ gamma2 +".pkl", 'wb') as mod1file:
  pickle.dump(mod1, mod1file)

