#!/bin/sh


if [ "$2" = "" ];then
echo Usage: $0 YYYY MM
exit
fi

YEAR=$1
MONTH=$2
STI2=$3
ENI2=$4
STJ2=$5
ENJ2=$6
NUM=$7
RG=$8

#added by gyin on 01-27-2021
current_day=${10}
current_time=${11}


SITE=$9
if [ "$9" = "siteA" ];then
  ydim=160
  xdim=120
elif [ "$9" = "siteB" ];then
  ydim=150
  xdim=140
elif [ "$9" = "siteC" ];then
  ydim=140
  xdim=140
elif [ "$9" = "siteD" ];then
  ydim=110
  xdim=112
elif [ "$9" = "siteE" ];then
  ydim=100
  xdim=80
fi

AA=1
NUM2=$((${NUM}+${AA}))

echo ${YEAR} ${MONTH} ${DAY} ${TIME}
###############
cat <<EOF > g2svm.f90
   program a2grd  
   parameter (nn1=${NUM})
   parameter (idim2=${ydim},jdim2=${xdim},nn2=39,nn2b=39) ! read every hour
   parameter (idim3=${ydim},jdim3=${xdim})
!!
   real mrain(idim3,jdim3,nn2b),mrain2(nn1,nn2b),mrain2b(nn1,nn2b)
   real mrainnm(idim3,jdim3,nn2b),mrainnm2(nn1,nn2b)
   real rrain(idim2,jdim2,nn2b),rrain2(nn1,nn2b)
!!
   integer ii3,nn3
!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   real dlon,dlat
   real lat5,lon5
   real rr,rr2,avemrain,summrain,avemrain2,summrain2
!!
   integer :: ii2,k,kk,irec2,irec3,ix,iy,iir
!!
   character :: y4m2*8,y4*4,m2*2,d2a*2,h2a*2
   character :: y4m2b*6
   character :: lon2*3,lat2*3
!!

!! aaa -----------------------------------------
!!-----------------------------------------
!!-----------------------------------------

! changed here by gyin for reading file from own mac address
!  OPEN (10,FILE='/goemon_disk2/trmmauto/AI_GSMaP/svm-msm-wj-201906/MSMGPV/data1/${SITE}/${YEAR}${MONTH}/rsms-${YEAR}${MONTH}.grd' &
   OPEN (10,FILE='/data37/gyin/run_fcst/MSMGPV_39hr/${SITE}/${YEAR}${MONTH}/${YEAR}${MONTH}${current_day}${current_time}/rsms-${YEAR}${MONTH}${current_day}${current_time}.grd' &
!    ,recl=idim2*jdim2,access='direct',status='old') !ifort
    ,recl=idim3*jdim3*4,access='direct',status='old') !gfortran


! added by GYIN 01-28-2021 DEBUG
!write(*,*) 'current_day=', ${current_day}
!write(*,*) 'current_time=', ${current_time}

!  OPEN (20,FILE='/goemon_disk2/trmmauto/AI_GSMaP/svm-msm-wj-201906/kaiseki/data1/${SITE}/${YEAR}${MONTH}/kaiseki-${YEAR}${MONTH}.grd' &
!    ,recl=idim2*jdim2*4,access='direct',status='old')  !gfortran
 
 irec2=1
! irec3=1
 
 do k=1,nn2
     kk=k

!!!!!!!!!!!!!!!!!!!!!
!!    GrADS INPUT
!!!!!!!!!!!!!!!!!!!!!
!! msm
    read(10,rec=irec2) ((mrain(i,j,kk),i=1,idim3),j=1,jdim3)
    irec2=irec2+1
!! radar
!   read(20,rec=irec3) ((rrain(i,j,kk),i=1,idim2),j=1,jdim2)
!    irec3=irec3+1
 end do

! added by gyin 01-29-2021 debug
!write(*,*) 'GYIN DEBUG', mrain(40,50,10)

 do ix= ${STI2},${ENI2}
  do iy= ${STJ2},${ENJ2}

 write(lon2,'(i3.3)') ix
 write(lat2,'(i3.3)') iy


  OPEN (30,FILE='${YEAR}${MONTH}${current_day}${current_time}-svm_'//lon2//'_'//lat2//'.dat',status='unknown') !collecting values in FV
  OPEN (40,FILE='${YEAR}${MONTH}${current_day}${current_time}-msm_'//lon2//'_'//lat2//'.dat',status='unknown') !collecting target value



 do k=1,nn2
   kk=k
   
   !rr=rrain(ix,iy,kk)
   
   !if(rr.le.0.101) then
   !  rr=0.0
   !end if

   ixs=int(ix)-${RG}
   ixe=int(ix)+${RG}
   iys=int(iy)-${RG}
   iye=int(iy)+${RG}

   ii=1
 
   do i=ixs,ixe
    do j=iys,iye
      
       if(mrain(i,j,kk).ge.0.) then
        mrain2(ii,kk)=mrain(i,j,kk)
       else
        mrain2(ii,kk)=0       
       end if  

       if(mrain2(ii,kk).lt.0.or.mrain2(ii,kk).ge.300.) then
         write(*,*) mrain2(ii,kk),ii,kk
       end if

       ii=ii+1

    end do  
   end do !end i

   ! modified by GYIN 01-28-2021
   write(30,'(${NUM}f9.3)') (mrain2(m,kk),m=1,nn1)
   write(40,'(f9.3)') mrain(ix,iy,kk)
   
   !if(rr.ge.0.) then
   ! write(30,'(${NUM2}f9.3)') (mrain2(m,kk),m=1,nn1),rr
   ! write(40,'(2f9.3)') mrain(ix,iy,kk),rr
   !end if

 end do !k

 end do
end do
!!!!!!!!!!!!!!!!!!!!!
!!
  STOP
  END program a2grd
EOF
###############
chmod +x g2svm.f90
rm -f ./g2svm
#ifort -O -o g2svm g2svm.f90
gfortran -O -o  g2svm g2svm.f90
./g2svm

##############

#rm g2svm.f90
#rm g2svm


if [ ! -e ./data-testing/${YEAR}${MONTH}${current_day}${current_time} ]; then
 mkdir ./data-testing/${YEAR}${MONTH}${current_day}${current_time}
fi

mv ${YEAR}${MONTH}${current_day}${current_time}-svm*.dat ./data-testing/${YEAR}${MONTH}${current_day}${current_time}

if [ ! -e ./data-msm/${YEAR}${MONTH}${current_day}${current_time} ]; then
 mkdir ./data-msm/${YEAR}${MONTH}${current_day}${current_time}
fi
mv ${YEAR}${MONTH}${current_day}${current_time}-msm*.dat ./data-msm/${YEAR}${MONTH}${current_day}${current_time}

###
## END grib2grads
###




