#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Programmed by RESTEC
based on Dr. Yoshikane's Program
modified by GYIN 01-29-2021 for forecast purpose
"""
"""
Usage
> python3 ./step02-ml_test1.py DIR2 YEAR MONTH gamma2 cost2 epsilon2 lon lat NUM2 NUM3 TIME2
"""



"""
Installed library
 sklearn
 pandas
 numpy
"""

import pandas as pd
import pickle
import numpy as np
from sklearn.metrics import mean_squared_error
from sklearn.metrics import mean_absolute_error
import sys
#引数から代入する場合はコメントアウトを外す

args = sys.argv

DIR2 = args[1]
YEAR = args[2]
MONTH = args[3]
gamma2 =args[4]
cost2 = args[5]
epsilon2 = args[6]
lon = args[7]
lat = args[8]
NUM2 = args[9]
NUM3 = args[10]
TIME2 = args[11]
current_day = args[12]
current_time = args[13]
DIR3 = "/data37/gyin/siteC_2007_2019/siteC_07/data-model/"+MONTH

dat1a = pd.read_table(DIR2 + "/data-svm/"+ YEAR + MONTH + current_day + current_time + "-svm_"+ lon + "_" + lat +".dat",delim_whitespace=True,header=None)
dat1b = pd.read_table(DIR2 + "/data-msm/"+ YEAR + MONTH + current_day + current_time + "/"+ YEAR + MONTH + current_day + current_time + "-msm_"+ lon + "_" + lat +".dat",delim_whitespace=True,header=None)

#1からTIME2までの数列の作成
x1a = np.arange(1,int(TIME2)+1,1).T
x1 = pd.DataFrame(x1a)


#識別器の読み込み
with open(DIR3 + "/mod1_"+ lon + "_" + lat +"-gamma_"+ gamma2 + "-cost_"+ cost2 + "-epsilon_" + epsilon2 +".pkl", 'rb') as mod1file:
  mod1 = pickle.load(mod1file)
  
#SVMでの予測
#データセットの作成
#説明変数を0からNUM2行まで取り出し、X2に代入
X2 = dat1a.iloc[:,0:int(NUM2)]

#X2を用いて予測 結果はpredictedY1
predictedY1a = mod1.predict(X2)

#predictedY1が0未満は0に
predictedY1a = np.where(predictedY1a < 0, 0, predictedY1a)
predictedY1 = pd.DataFrame(predictedY1a)

# commented by gyin 01-28-2021
#obs = dat1a.iloc[:,int(NUM3)-1]
sim = dat1b.iloc[:,0]

# predicted versus obs
#rmse2 = np.sqrt(mean_squared_error(predictedY1a, obs))
#mse2=mean_squared_error(predictedY1a, obs)
#mae2=mean_absolute_error(predictedY1a, obs)
#cor2=np.corrcoef(predictedY1a, obs)[0, 1]

# sim versus obs
#rmse3 = np.sqrt(mean_squared_error(sim, obs))
#mae3=mean_absolute_error(sim, obs)
#cor3=np.corrcoef(sim, obs)[0, 1]


# modified by gyin 01-28-2021
## x1,predictedY1,obs,sim,rmse2,mae2,cor2,rmse3,mae3,cor3をx2に結合
#x2 = pd.concat([x1,predictedY1,obs,sim], axis=1)
#x2.columns = ['prediction_time', 'estimated_prec','obs','sim']
#x2.index = x2.index + 1
##x2['rmse2'] = rmse2
##x2['mae2'] = mae2
##x2['cor2'] = cor2
##x2['rmse3'] = rmse3
##x2['mae3'] = mae3
##x2['cor3'] = cor3

x2 = pd.concat([x1,predictedY1,sim], axis=1)
x2.columns = ['prediction_time', 'ml','sim']
x2.index = x2.index + 1

#x2の出力
# changed by gyin 11-24-2020 save file based on time instead of pixel (maybe change it to be based on pixel later)
#x2.to_csv(DIR2 + "/data-out-point/data-out-" + lon + lat +"/output-"+ YEAR + MONTH +"-" + lon + "_" + lat + "_" + gamma2 + "_" + cost2 + "_" + epsilon2  +".csv", header=True, index=True)
x2.to_csv(DIR2 + "/data-out/" + YEAR + MONTH + current_day + current_time + "/output-"+ YEAR + MONTH + current_day + current_time + "-" + lon + "_" + lat +".csv", header=True, index=False)





