#!/bin/sh

if [ "$2" = "" ] ; then
echo Usage: $0 YYYY MM 
exit
fi
#
YEAR=$1
MONTH=$2
STI=$3
ENI=$4
STJ=$5
ENJ=$6
gamma2=$7
cost2=$8
epsilon2=$9
current_day=${10}
current_time=${11}

# The number of svm convert in a month (31days: 243) ** 247
TIME2=39

# Current dir
DIR2=`pwd`
RDIR=/home/yoshikane/R-3.6.3/bin
# GYIN 03-08-2021
DIR3="/data37/gyin/paper_exp/cross07_2007_2019"

# 11years
YEAR1="2007"
YEAR2="2008"
YEAR3="2009"
YEAR4="2010"
YEAR5="2011"
YEAR6="2012"
YEAR7="2013"
YEAR8="2014"
YEAR9="2015"
YEAR10="2016"
YEAR11="2017"
YEAR12="2018"
YEAR13="2019"
##
if [ ! -e ./data-out-cdft/${YEAR}${MONTH}${current_day}${current_time} ]; then
 mkdir ./data-out-cdft/${YEAR}${MONTH}${current_day}${current_time}
fi
#
echo "CDFt", ${YEAR},${MONTH},${current_day},${current_time}
#
#rm ./data-svm/*
#
for lon in `seq -f "%03g" ${STI} ${ENI}`
 do
 for lat in `seq -f "%03g" ${STJ} ${ENJ}`
  do
     # GYIN 03-08-2021
     #lon2=${lon:1:2}
     #lat2=${lat:1:2}
     lon2=${lon}
     lat2=${lat}
###############

cat<<EOF>test.R1
library( e1071 )
library(CDFt)
library(MLmetrics)

dat2a.df <- read.table("${DIR3}/data-out/${YEAR1}${MONTH}/output-${YEAR1}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2b.df <- read.table("${DIR3}/data-out/${YEAR2}${MONTH}/output-${YEAR2}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2c.df <- read.table("${DIR3}/data-out/${YEAR3}${MONTH}/output-${YEAR3}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2d.df <- read.table("${DIR3}/data-out/${YEAR4}${MONTH}/output-${YEAR4}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2e.df <- read.table("${DIR3}/data-out/${YEAR5}${MONTH}/output-${YEAR5}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2f.df <- read.table("${DIR3}/data-out/${YEAR6}${MONTH}/output-${YEAR6}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2g.df <- read.table("${DIR3}/data-out/${YEAR7}${MONTH}/output-${YEAR7}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2h.df <- read.table("${DIR3}/data-out/${YEAR8}${MONTH}/output-${YEAR8}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2i.df <- read.table("${DIR3}/data-out/${YEAR9}${MONTH}/output-${YEAR9}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2j.df <- read.table("${DIR3}/data-out/${YEAR10}${MONTH}/output-${YEAR10}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2k.df <- read.table("${DIR3}/data-out/${YEAR11}${MONTH}/output-${YEAR11}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2l.df <- read.table("${DIR3}/data-out/${YEAR12}${MONTH}/output-${YEAR12}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)
dat2m.df <- read.table("${DIR3}/data-out/${YEAR13}${MONTH}/output-${YEAR13}${MONTH}-${lon2}_${lat2}_${gamma2}_${cost2}_${epsilon2}.csv",sep=",",skip=1)

x1=(1:${TIME2})


if( ${YEAR} == 2007){
dat1a.df <- dat2a.df
dat1.df <- rbind(dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2008){
dat1a.df <- dat2b.df
dat1.df <- rbind(dat2a.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2009){
dat1a.df <- dat2c.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2010){
dat1a.df <- dat2d.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2011){
dat1a.df <- dat2e.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2012){
dat1a.df <- dat2f.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2013){
dat1a.df <- dat2g.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2014){
dat1a.df <- dat2h.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2015){
dat1a.df <- dat2i.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2016){
dat1a.df <- dat2j.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2k.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2017){
dat1a.df <- dat2k.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2l.df,dat2m.df)
}else if(${YEAR} == 2018){
dat1a.df <- dat2l.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2m.df)
}else if(${YEAR} == 2019){
dat1a.df <- dat2l.df
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df)
}else if(${YEAR} ==2020){
dat1a.df <- read.table("${DIR2}/data-out/${YEAR}${MONTH}${current_day}${current_time}/output-${YEAR}${MONTH}${current_day}${current_time}-${lon}_${lat}.csv",sep=",",skip=1)
dat1.df <- rbind(dat2a.df,dat2b.df,dat2c.df,dat2d.df,dat2e.df,dat2f.df,dat2g.df,dat2h.df,dat2i.df,dat2j.df,dat2k.df,dat2l.df,dat2m.df)
}else{
}  

# GYIN 03-08-2021 (dat1a.df does not have obs)
#dat1m.df <- rbind(dat1.df,dat1a.df)

## replace
dat1.df[dat1.df < 0.1] = 0
dat1.df <- data.frame(dat1.df)
dat1a.df[dat1a.df < 0.1] = 0
dat1a.df <- data.frame(dat1a.df)

#print(dim(dat1.df))
#print(dim(dat1a.df))
#dat1a.df[,2]


# GYIN 03-08-2021
sim3.df <- dat1a.df[,2]
sim3 <- sim3.df
#obs3.df <- dat1a.df[,3]
#obs3 <- data.frame(obs3.df)
#msm3.df <- dat1a.df[,4]
#msm3 <- data.frame(msm3.df)
#sim4.df <- dat1m.df[,2]
#sim4 <- sim4.df

msm3.df <- dat1a.df[,3]
msm3 <- data.frame(msm3.df)
sim4.df <- c(dat1.df[,2],dat1a.df[,2])
sim4 <- sim4.df

#------------------

sim2 <- dat1.df[,2] 
obs2 <- dat1.df[,3]

sim2[sim2 < 0.1] = 0
obs2[obs2 < 0.1] = 0

sim4[sim4 < 0.1] = 0

##
#class(sim4)
#class(sim2)
#class(obs2)

#sim4
#sim2
#obs2

obs2 = na.omit(obs2)
sim2 = na.omit(sim2)

#
CT <- CDFt(obs2,sim2,sim4)
x <- CT\$x     
ds <- CT\$DS

ds2 <- tail(ds, n=39) 

for(i in 1:39){
if(sim3[i] < 0.1){ 
   ds2[i] = 0
}else{
   ds2[i] = ds2[i]
}
}

x2 <- data.frame(x1,ds2,sim3,msm3)
#x2 <- data.frame(x1, ds2, sim3, obs3, msm3)
#x2 <- data.frame(x1, svmcdf, svm, obs, sim, cor2, cor3, cor4, rmse2, rmse3, rmse4, mae2, mae3, mae4) 
#x3 <- data.frame(cor2, cor3, cor4, rmse2, rmse3, rmse4, mae2, mae3, mae4) 
#x3

write.csv(x2, "${DIR2}/data-out-cdft/${YEAR}${MONTH}${current_day}${current_time}/output-${YEAR}${MONTH}${current_day}${current_time}-${lon}_${lat}.csv")
#quit()
EOF
 
${RDIR}/R --vanilla --no-slave <  test.R1
#R --vanilla --no-slave <  test.R1

 done
done










